#### Parse cmd line args ####
args <- commandArgs(trailingOnly = TRUE)

invokeError <- function() {
	write("Supply an argument (--paper/--new)", file="")
	quit(status=11)
}
if (length(args) == 1) {
	if (args[1] == "--paper") {
		input <- "LOSTestLog-JDK-paper-version.csv"
			oldName <- TRUE
	} else if (args[1] == "--new") {
		input <- "LOSTestLog-JDK-new-eval.csv"
			oldName <- FALSE
	} else {
		invokeError()
	}
} else {
	invokeError()
}

v<-read.csv2(input,header=FALSE,col.names=c("git","time","name","avg","sd","err"), sep = ";", dec = ".")

# Change to disable generation of new graphs
newPdf <- TRUE

####

maxStdDev <- 1:12
interpOverhead <- 1:12
optimTime <- 1:12

#to change order see for loop below

if (oldName) {
	benchmarks=c(
	"CI_CONFUSED_INHERITANCE",
	"UUF_UNUSED_FIELD",
	"DM_GC",
	"FI_PUBLIC_SHOULD_BE_PROTECTED-2",
	"SE_NO_SUITABLE_CONSTRUCTOR",
	"IMSE_DONT_CATCH_IMSE",
	"CO_SELF_NO_OBJECT/CO_ABSTRACT_SELF",
	"EQ_ABSTRACT_SELF",
	"DM_RUN_FINALIZERS_ON_EXIT",
	"CN_IDIOM",
	"CN_IDIOM_NO_SUPER_CALL",
	"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"
	)
} else {
	#There's only one renaming now!
	benchmarks=c(
	"PROTECTED_FIELD",
	"UNUSED_PRIVATE_FIELD",
	"GC_CALL",
	"FINALIZER_NOT_PROTECTED-2",
	"NO_SUITABLE_CONSTRUCTOR",
	"DONT_CATCH_IMSE",
	"COVARIANT_COMPARETO",
	"COVARIANT_EQUALS",
	"RUN_FINALIZERS_ON_EXIT",
	"NO_CLONE",
	"SUPER_CLONE_MISSING",
	"NOT_CLONEABLE"
	)
}

benchmarknames=c(
"PROTECTED_FIELD",
"UNUSED_PRIVATE_FIELD",
"GC_CALL",
"FINALIZER_NOT_PROTECTED",
"NO_SUITABLE_CONSTRUCTOR",
"DONT_CATCH_IMSE",
"COVARIANT_COMPARETO",
"COVARIANT_EQUALS",
"RUN_FINALIZERS_ON_EXIT",
"NO_CLONE",
"SUPER_CLONE_MISSING",
"NOT_CLONEABLE"
)

#write("Name&Base&Los&LosOpt&\\\\\\midrule",file="table.tex",append=FALSE)
write("",file="table.tex",append=FALSE)
write("",file="evalResLos.tex",append=FALSE)
write("",file="indexes.tex",append=FALSE)

plusminus <- "$&$\\pm$&$"
benchIdx <- function(id, ltxName)
{
	idx<-subset(v,name==id)
	idxMean<-mean(idx$avg)
	idxSd<-sd(idx$avg)
	idxMeanForm<-format(round(idxMean,digits=2),nsmall=2)
	idxSdForm <- format(round(idxSd,digits=2),nsmall=2)
	write(paste(
		#"{\\scriptsize ",ltxName,"}&$",
		ltxName,"&$",
		#format(signif(aReal,digits=2),nsmall=2),plusminus,format(signif(aRealSd,digits=1),nsmall=2),"$&",
		#Final choice: use both round and format(...,nsmall=2) to show a
		#fixed number of digits.
		idxMeanForm,plusminus,idxSdForm,"$",
		"\\\\",
		#"\\includegraphics[scale=.2]{graphs/foo.pdf}\\\\",
	sep=""), file="indexes.tex",append=TRUE)
}
benchIdx("Reading all class files", "Reading class files")

if (oldName) {
	benchIdx("Method-name index creation (for e.g. FI_PUBLIC_SHOULD_BE_PROTECTED)", "Method name")
	benchIdx("Exception-handler-type index creation (for e.g. IMSE_DONT_CATCH_IMSE)", "Exception handlers")
} else {
	benchIdx("Method-name index creation (for e.g. FINALIZER_NOT_PROTECTED)", "Method name")
	benchIdx("Exception-handler-type index creation (for e.g. DONT_CATCH_IMSE)", "Exception handlers")
}

benchIdx("Instructions type-index creation", "Instruction type")

roundmax <- function(nums)
{
	round(max(nums) * 100, digits=1)
}
sdSum <- function(sd1, sd2)
{
	sqrt(sd1^2 + sd2^2)
}
#Computes avg(vect1) / avg(vect2) with std. var
#TODO: use three columns instead of one to ensure alignment, and update Eval*.tex
ratioWithSd <- function(vect1, vect2)
{
	mean1 <- mean(vect1)
	sd1 <- sd(vect1)
	mean2 <- mean(vect2)
	sd2 <- sd(vect2)
	meanRatio <- mean1/mean2
	relativeRatioVariance = (sd1/mean1)^2 + (sd2/mean2)^2
	sdRatio = sqrt(relativeRatioVariance) * meanRatio
	#list(avg=meanRatio, std=sdRatio) # How to return a list with named fields
	sep <- "$&$\\pm$&$"
	paste("$", round(meanRatio, digits=1), plusminus, round(sdRatio, digits=1), "$")
}
produceplot <- function(benchmark, benchmarkname,i) 
{
	bName<-gsub("_","-",benchmark)
	bName<-gsub("/","-",bName)
	ltxName<-gsub("_","\\\\_",benchmarkname)

	bBase<-subset(v,name==benchmark)
	bLos<-subset(v,name==paste(benchmark,"Los"))
	bLosOpt<-subset(v,name==paste(benchmark,"Los - after optimization"))
	bLosOptTime<-subset(v,name==paste(benchmark,"Los Optimization"))
	#bLosOptTimeSum<-bLosOpt + bLosOptTime #XXX Summing std.devs is bad!
	bLosOptTimeSum_avg<-bLosOpt$avg + bLosOptTime$avg
	#bLosOptTimeSum_sd<-bLosOpt$sd + bLosOptTime$sd #XXX Summing std.devs is bad!
	#print(bLosOptTime)
	print(bLosOptTimeSum_avg)
	#print(bLosOptTimeSum_sd)

	#print(bBase)
	#print("Max std.deviation:", quote=FALSE)
	write(paste("Max std.deviation for ", benchmark, ": (Base, SQu, SQuOpt, SQuOpt+Optim)", sep=""), file="")
	write(paste(roundmax(bBase$sd/bBase$avg),roundmax(bLos$sd/bLos$avg),roundmax(bLosOpt$sd/bLosOpt$avg),roundmax(bLosOptTime$sd/bLosOptTime$avg)),
file="")

	aBase<-mean(bBase$avg)
	aLos<-mean(bLos$avg)
	aLosOpt<-mean(bLosOpt$avg)
	aLosOptTime<-mean(bLosOptTime$avg)
	aLosOptTimeSum<-mean(bLosOptTimeSum_avg)
	lows<-c(mean(bLosOptTimeSum_avg)-sd(bLosOptTimeSum_avg),
		mean(bLosOpt$avg)-sd(bLosOpt$avg),
		mean(bLos$avg)-sd(bLos$avg),
		mean(bBase$avg)-sd(bBase$avg))
	highs<-c(mean(bLosOptTimeSum_avg)+sd(bLosOptTimeSum_avg),
		mean(bLosOpt$avg)+sd(bLosOpt$avg),
		mean(bLos$avg)+sd(bLos$avg),
		mean(bBase$avg)+sd(bBase$avg))
	hMax<-max(highs)*1.03

	aInterpOverhead <- aBase/aLos
	interpOverhead[i] <<- 1/aInterpOverhead
	optimTime[i] <<- aLosOptTime

	write(paste(
		"{\\scriptsize ",ltxName,"}&$",
		#format(signif(aBase,digits=2),nsmall=2),plusminus,format(signif(sd(bBase$avg),digits=1),nsmall=2),"$&",
		#Final choice: use both round and format(...,nsmall=2) to show a
		#fixed number of digits.
		format(round(aBase,digits=2),nsmall=2),plusminus,format(round(sd(bBase$avg),digits=2),nsmall=2),"$&$",
		format(round(aLosOptTime,digits=2),nsmall=2),plusminus,format(round(sd(bLosOptTime$avg),digits=2),nsmall=2),"$&",
		round(aInterpOverhead,digits=1), "x&",
		#round(aBase/aLosOpt,digits=1), "x&",
		ratioWithSd(bBase$avg,bLosOpt$avg), "x&",
		ratioWithSd(bBase$avg,bLosOptTimeSum_avg), "x&",
		"\\includegraphics[scale=.2]{\\graphPath{",bName,".pdf}}\\\\"
	,sep=""),file="table.tex",append=TRUE)

	if (newPdf) {
		pdf(paste(bName,".pdf",sep=""),width=8,height=1)
		par(mar=c(0,0,0,0))
		mr<-barplot(c(aLosOptTimeSum,aLosOpt,aLos,aBase),horiz=TRUE,space=0,col=c("gray30","gray50","gray80","white"),axes=FALSE,xlim=c(0,hMax))
		arrows(lows, mr, highs, mr, length = 0.07, angle = 90, 
	       code = 3, lty = 1)
		dev.off()
	}
	#Must use <<-!
	maxStdDev[i] <<- roundmax(c(bBase$sd/bBase$avg,bLos$sd/bLos$avg,bLosOpt$sd/bLosOpt$avg,bLosOptTime$sd/bLosOptTime$avg))
}

#change order here if desired, e.g. c(5,2,3,1,4) instead of 1:5
#for (b in 1:12)
for (b in c(11,1,2,10,7,3,9,12,8,4,6))
	produceplot(benchmarks[b],benchmarknames[b],b)
write(paste("\\newcommand{\\MaxDevExp}{", max(maxStdDev), "}", sep=""),file="evalResLos.tex",append=TRUE)
write(paste("\\newcommand{\\minInterpOver}{", round(min(interpOverhead),digits=1), "}", sep=""),file="evalResLos.tex",append=TRUE)
write(paste("\\newcommand{\\maxInterpOver}{", round(max(interpOverhead),digits=1), "}", sep=""),file="evalResLos.tex",append=TRUE)
write(paste("\\newcommand{\\minOptimTime}{", round(min(optimTime),digits=1), "}", sep=""),file="evalResLos.tex",append=TRUE)
write(paste("\\newcommand{\\maxOptimTime}{", round(max(optimTime),digits=1), "}", sep=""),file="evalResLos.tex",append=TRUE)
#warnings()



	# pdf(paste(idx,".pdf",sep=""),width=2,height=.25)
	# par(mar=c(0,0,0,0), ps = 18)
	# if (idx < 10)
		# boxplot(data[idx],frame.plot=FALSE,xaxt="n",outcol = 		"gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=1)
	# else boxplot(data[idx],frame.plot=FALSE,xaxt="n",outcol = "gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=1)
	# abline(v=0,col="gray")
	# boxplot(data[idx],xaxt="n",frame.plot=FALSE,horizontal=TRUE,ylim=c(0,25),width=0.9,add=TRUE,boxwex = 0.5)
	# points(1,mean(data[idx]),pch=5)
	# dev.off()
	# embedFonts(paste(idx,".pdf",sep=""),options="-dSubsetFonts=true -dEmbedAllFonts=true -dSAFER -dNOPLATFONTS -dPDFSETTINGS=/printer -dMaxSubsetPct=100")
		# write(paste(labelnames[idx],"&\\includegraphics[scale=\\scalefactor]{",idx,".pdf}&",round(sapply(data[idx], mean, na.rm = TRUE),2),"&",N,"\\\\",sep=""),file="dataRT.tex",append=TRUE)

	# write(paste(labelnames[idx],"&\\includegraphics{",idx,".pdf}&",N,"\\\\",sep=""),file="dataRT.tex",append=TRUE)
# if (idx <= 10)
	# boxplot(data[idx],frame.plot=FALSE,outcol = "gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=1)
# }

# produceboxplot(1, "124")
# produceboxplot(2, "123")
# produceboxplot(3, "121")
# produceboxplot(4, "117")
# produceboxplot(5, "118")
# produceboxplot(6, "111")
# produceboxplot(7, "92")
# produceboxplot(8, "82")
# produceboxplot(9, "78")
# produceboxplot(10, "30")
# pdf("axis.pdf",width=2,height=1.5)
# par(mar=c(2,0,0,0), ps = 10)
# boxplot(data[10],frame.plot=FALSE,outcol = "gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=.1)
# dev.off()
