fbData<-read.csv2("FB-startup-JDK.csv",header=FALSE,col.names=c("git","real","user","sys","cpuUsage"), sep = ";", dec = ".")
losData<-read.csv2("LOS-startup-JDK.csv",header=FALSE,col.names=c("git","real","user","sys","cpuUsage"), sep = ";", dec = ".")

#write("Name&Real&Los&LosOpt&\\\\\\midrule",file="table.tex",append=FALSE)
write("",file="table2.tex",append=FALSE)
write("",file="evalRes.tex",append=FALSE)

produceplot <- function(v, name, ltxName)
{
	print(v)

	aReal<-mean(v$real)
	aRealSd <- sd(v$real)
	aUser<-mean(v$user + v$sys)
	aUserSd <- sd(v$user + v$sys)
	print(paste(aReal, aRealSd, paste(round(aRealSd/aReal * 100, digits=1),
					"%", sep="")), quote=FALSE)
	print(paste(aUser, aUserSd, paste(round(aUserSd/aUser * 100, digits=1),
					"%", sep="")), quote=FALSE)
	lows<-c(aReal-aRealSd, aUser-aUserSd)
	highs<-c(aReal+aRealSd, aUser + aUserSd)
	hMax<-max(highs)*1.03
	ltxName

	aRealForm<-format(round(aReal,digits=2),nsmall=2)
	aRealSdForm <- format(round(aRealSd,digits=2),nsmall=2)
	aUserForm<-format(round(aUser,digits=2),nsmall=2)
	aUserSdForm <- format(round(aUserSd,digits=2),nsmall=2)
	sep <- "$&$\\pm$&$"
	write(paste(
		#"{\\scriptsize ",ltxName,"}&$",
		ltxName,"&$",
		#format(signif(aReal,digits=2),nsmall=2),sep,format(signif(aRealSd,digits=1),nsmall=2),"$&",
		#Final choice: use both round and format(...,nsmall=2) to show a
		#fixed number of digits.
		aRealForm,sep,aRealSdForm,"$&$",
		aUserForm,sep,aUserSdForm,"$",
		"\\\\",
		#"\\includegraphics[scale=.2]{graphs/foo.pdf}\\\\",
	sep=""),file="table2.tex",append=TRUE)
	write(paste("\\newcommand{\\avgRealTime", name, "}{", aRealForm, "}", sep=""),file="evalRes.tex",append=TRUE)
	write(paste("\\newcommand{\\avgRealSd", name, "}{", aRealSdForm, "}", sep=""),file="evalRes.tex",append=TRUE)
	write(paste("\\newcommand{\\avgUserTime", name, "}{", aUserForm, "}", sep=""),file="evalRes.tex",append=TRUE)
	write(paste("\\newcommand{\\avgUserSd", name, "}{", aUserSdForm, "}", sep=""),file="evalRes.tex",append=TRUE)

#	pdf(paste(bName,".pdf",sep=""),width=8,height=1)
#	par(mar=c(0,0,0,0))
#	mr<-barplot(c(aLosOpt,aLos,aReal),horiz=TRUE,space=0,col=c("gray50","gray80","white"),axes=FALSE,xlim=c(0,hMax))
#	arrows(lows, mr, highs, mr, length = 0.07, angle = 90, 
#       code = 3, lty = 1)
#	dev.off()
}

#change order here if desired, e.g. c(5,2,3,1,4) instead of 1:5
#for (b in 1:12)
produceplot(fbData, "Fb", "FindBugs")
produceplot(losData, "Los", "\\LoS{}")




	# pdf(paste(idx,".pdf",sep=""),width=2,height=.25)
	# par(mar=c(0,0,0,0), ps = 18)
	# if (idx < 10)
		# boxplot(data[idx],frame.plot=FALSE,xaxt="n",outcol = 		"gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=1)
	# else boxplot(data[idx],frame.plot=FALSE,xaxt="n",outcol = "gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=1)
	# abline(v=0,col="gray")
	# boxplot(data[idx],xaxt="n",frame.plot=FALSE,horizontal=TRUE,ylim=c(0,25),width=0.9,add=TRUE,boxwex = 0.5)
	# points(1,mean(data[idx]),pch=5)
	# dev.off()
	# embedFonts(paste(idx,".pdf",sep=""),options="-dSubsetFonts=true -dEmbedAllFonts=true -dSAFER -dNOPLATFONTS -dPDFSETTINGS=/printer -dMaxSubsetPct=100")
		# write(paste(labelnames[idx],"&\\includegraphics[scale=\\scalefactor]{",idx,".pdf}&",round(sapply(data[idx], mean, na.rm = TRUE),2),"&",N,"\\\\",sep=""),file="dataRT.tex",append=TRUE)

	# write(paste(labelnames[idx],"&\\includegraphics{",idx,".pdf}&",N,"\\\\",sep=""),file="dataRT.tex",append=TRUE)
# if (idx <= 10)
	# boxplot(data[idx],frame.plot=FALSE,outcol = "gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=1)
# }

# produceboxplot(1, "124")
# produceboxplot(2, "123")
# produceboxplot(3, "121")
# produceboxplot(4, "117")
# produceboxplot(5, "118")
# produceboxplot(6, "111")
# produceboxplot(7, "92")
# produceboxplot(8, "82")
# produceboxplot(9, "78")
# produceboxplot(10, "30")
# pdf("axis.pdf",width=2,height=1.5)
# par(mar=c(2,0,0,0), ps = 10)
# boxplot(data[10],frame.plot=FALSE,outcol = "gray",horizontal=TRUE,pch=16,ylim=c(0,25),width=.1)
# dev.off()
